/*------------------------------
Programs are fundamentally strings.
There are several types of strings in SQL, 
though I recommend varchar or nvarchar for programming.  
I'll be using varchar for all these examples, 
 which works great assuming you have standard alphanumeric names 
in your table definitions.  

There are a lot of string functions, but I'll focus on 
some of the most useful ones.  

ASCII	LTRIM	SOUNDEX
CHAR	NCHAR	SPACE
CHARINDEX	PATINDEX	STR
CONCAT	QUOTENAME	STRING_ESCAPE
DIFFERENCE	REPLACE	STRING_SPLIT
FORMAT	REPLICATE	STUFF
LEFT	REVERSE	SUBSTRING
LEN	RIGHT	UNICODE
LOWER	RTRIM	UPPER
*/
SELECT
	LEN ('mailman') as length,
	LEFT('mailman',4) as Left4,
	RIGHT('mailman',3) as Right3,
	SUBSTRING('mailman',3,4) as Mid4,
	REPLACE('mailman','ail','er') as Replace

exec sp_find_acronym 'I''m so Meta, even this acronym'
